<?php 
$about_section = get_theme_mod( 'martial_arts_training_pro_product_enable' );
if ( 'Disable' == $about_section ) {
  return;
}
if( get_theme_mod('martial_arts_training_pro_product_bgcolor') ) {
  $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_product_bgcolor')).';';
}elseif( get_theme_mod('martial_arts_training_pro_product_bgimage') ){
  $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_product_bgimage')).'\')';
}else{
  $about_backg = '';
}
?>
<?php if ( class_exists( 'WooCommerce' ) ) { ?>
<section id="product" style="<?php echo esc_attr($about_backg); ?>">
	<div class="container">
		<div class="product_head">
            <?php if(get_theme_mod('martial_arts_training_pro_product_main_heading')!=''){ ?>
	            <h3 class="pb-0 m-0">
	              <?php echo esc_html(get_theme_mod('martial_arts_training_pro_product_main_heading')); ?>
	            </h3>
            <?php } ?>
			<img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_product_title_img')); ?>">
		</div>
	    <div class="owl-carousel mt-5">
	        <?php 
	          $args = array( 
	            'post_type' => 'product',
	            'posts_per_page' => get_theme_mod('martial_arts_training_pro_product_number'),
	            'product_cat' => get_theme_mod('martial_arts_training_pro_product_category'),
	            );
	            $loop = new WP_Query( $args );
	            $loop_index = 0;               
	             while ( $loop->have_posts() ) : $loop->the_post(); global $product;
	            ?>
	        <div class="product_content">               
	            <?php if (has_post_thumbnail( $loop->post->ID )) echo get_the_post_thumbnail($loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(woocommerce_placeholder_img_src()).'" alt="Placeholder" />'; ?>                            
	            <h5 class="product_head text-center mb-0 p-0"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
	           	<p class="mb-0"><?php echo esc_html(get_post_meta($post->ID,'custom-field-slug',true)); ?></p>
	            <ul class="">
              		<?php 
              		$rating_value = $product->get_average_rating();
	                  if ($rating_value <= 0) {
	                    echo '<li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li>';
	                  }else if($rating_value <= 1){
	                     echo '<li><i class="fas fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li>';
	                  }
	                  else if($rating_value <= 2){
	                     echo '<li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li>';
	                  }
	                  else if($rating_value <= 3){
	                     echo '<li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="far fa-star"></i></li><li><i class="far fa-star"></i></li>';
	                  }else if($rating_value <= 4){
	                     echo '<li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="far fa-star"></i></li>';
	                  }else{
	                     echo '<li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star"></i></li>';
	                  }?>    
              		<li class="right"><?php echo $product->get_price_html(); ?></li>
	            </ul>
	            <div class="product_btn">
	               	<a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>">
                      <?php echo esc_html(get_theme_mod('martial_arts_training_pro_product_btn')); ?>
                    </a>
	           	</div>
	        </div>
	        <?php endwhile; wp_reset_query(); ?>
	    </div>
	</div>
</section>
<?php }else{ ?>
  <?php if( current_user_can('administrator') ) { 
    $none = get_theme_mod('martial_arts_training_pro_pro_tab_woo_msg');
    if($none == "Disable"){
      $Disable = "none";
    }
  ?>  
  <h5 class="woo-smg text-center" style="display: <?php echo $Disable ?>">
    <?php echo esc_html('Install WooCommerce plugin to display this section','martial-arts-training-pro'); ?>
  </h5>
  <?php } ?>
<?php } ?>
