<?php 
$about_section = get_theme_mod( 'martial_arts_training_pro_pricing_enable' );
if ( 'Disable' == $about_section ) {
  return;
}
if( get_theme_mod('martial_arts_training_pro_pricing_bgcolor') ) {
  $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_pricing_bgcolor')).';';
}elseif( get_theme_mod('martial_arts_training_pro_pricing_bgimage') ){
  $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_pricing_bgimage')).'\')';
}else{
  $about_backg = '';
}

?>
<section id="pricing" style="<?php echo esc_attr($about_backg); ?>">
<div class="container">
	<div class="pricing-head">
		<div class="col-lg-12 col-md-12">
			<?php if(get_theme_mod('martial_arts_training_pro_pricing_main_heading')!=''){ ?>
	            <h3 class="pb-0 m-0">
	              <?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_main_heading')); ?>
	            </h3>
            <?php } ?>
            <img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_pricing_title_img')); ?>">
		</div>
	</div>
	<div class="row owl-carousel">
		<?php 
		$count=get_theme_mod('martial_arts_training_pro_pricing_number');
		for($i=1;$i<=$count;$i++){
		?>
			<div class="pricingTable">
                <span class="pricing-label">Featured</span>
                <h6 class="plan p-0 m-0"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_plan'.$i)); ?></h6>
                <div class="price-value">
                    <span class="currency"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_currency'.$i)); ?></span>
                    <span class="amount"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_price'.$i)); ?></span>
                    <span class="month"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_month'.$i)); ?></span>
                </div>
                <h6 class="free"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_free'.$i)); ?></h6>
                <ul class="pricing-content">
                    <li><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_feature1'.$i)); ?></li>
                    <li><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_feature2'.$i)); ?></li>
                    <li><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_feature3'.$i)); ?></li>
                    <li><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_feature4'.$i)); ?></li>
                    <li><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_feature5'.$i)); ?></li>
                </ul>
                <a href="<?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_btn_url'.$i)); ?>" class="pricingTable-signup"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_pricing_btn'.$i)); ?></a>
            </div>
		<?php } ?>
	</div>
</div>
</section>