<?php 
$about_section = get_theme_mod( 'martial_arts_training_pro_latest_news_enable' );
if ( 'Disable' == $about_section ) {
  return;
}
if( get_theme_mod('martial_arts_training_pro_latest_news_bgcolor') ) {
  $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_latest_news_bgcolor')).';';
}elseif( get_theme_mod('martial_arts_training_pro_latest_news_bgimage') ){
  $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_latest_news_bgimage')).'\')';
}else{
  $about_backg = '';
}

?>
<section id="latest_news" style="<?php echo esc_attr($about_backg); ?>">
	<div class="container">
		<div class="latest-news-head">
			<?php if(get_theme_mod('martial_arts_training_pro_latest_news_main_heading')!=''){ ?>
	            <h3 class="pb-0 m-0">
	              <?php echo esc_html(get_theme_mod('martial_arts_training_pro_latest_news_main_heading')); ?>
	            </h3>
            <?php } ?>
            <img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_latest_title_img')); ?>">
		</div>
		<div class="owl-carousel mt-5">
			<?php
			$args = array(
				'post_type' => 'post',
				'post_status' => 'publish',
				'posts_per_page' => get_theme_mod('martial_arts_training_pro_latest_news_number')
			);
			$new = new WP_Query($args); 
			$loop_index = 0; $i=1;
			while ( $new->have_posts() ){
				$new->the_post(); ?>
				<div class="news-content">
					<div class="news-image">
						<?php the_post_thumbnail(); ?>
						<span class="date"><?php echo get_the_date('M j Y') ?></span>
					</div>
					<div class="content_style">
						<ul>
							<li><span class="entry-author mr-2"><i class="far fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?></a></span></li>
							<li><span class="entry-comments"><i class="fas fa-comments"></i> <?php comments_number( __('0 Comments','martial-arts-training-pro'), __('0 Comments','martial-arts-training-pro'), __('% Comments','martial-arts-training-pro')); ?></span></li>
						</ul>
						<div class="news_head">
							<h5 class="m-0 p-0"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> </h5>
						</div>
			        </div>
				</div>
			<?php }
               wp_reset_query(); ?>
		</div>
	</div>
</section>