<?php 
$about_section = get_theme_mod( 'martial_arts_training_pro_diet_enable' );
if ( 'Disable' == $about_section ) {
  return;
}
if( get_theme_mod('martial_arts_training_pro_diet_bgcolor') ) {
  $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_diet_bgcolor')).';';
}elseif( get_theme_mod('martial_arts_training_pro_diet_bgimage') ){
  $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_diet_bgimage')).'\')';
}else{
  $about_backg = '';
}

?>
<section id="diet" style="<?php echo esc_attr($about_backg); ?>">
	<div class="container">
		<div class="diet-head">
			<?php if(get_theme_mod('martial_arts_training_pro_diet_main_heading')!=''){ ?>
	            <h3 class="pb-0 m-0">
	              <?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_main_heading')); ?>
	            </h3>
            <?php } ?>
            <img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_diet_title_img')); ?>">
		</div>
		<div class="row mt-4">
			<div class="col-lg-6 col-md-6">
				<div class="left_side">
					<img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_diet_left_img')); ?>">
				</div>
			</div>
			<div class="col-lg-6 col-md-6 mt-3">
				<div class="row">
					<?php 
					$diet_count = get_theme_mod('martial_arts_training_pro_diet_count');
					for($i=1; $i<=$diet_count; $i++) { ?>
						<div class="col-lg-6 col-md-6 col-sm-6 mt-4">
							<div class="box">
				                <img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_diet_img'.$i)); ?>">
				                <h5 class="head"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_title'.$i)); ?></h5>
				                <div class="box-content">
				                    <h5 class="title p-0"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_title'.$i)); ?></h5>
				                    <p class="post"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_text'.$i)); ?></p>
				                    <a href="<?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_btn_url'.$i)); ?>" class=""><?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_btn'.$i)); ?><span><i class="<?php echo esc_html(get_theme_mod('martial_arts_training_pro_diet_btn_icon'.$i)); ?>"></i></span></a>
				                </div>
				            </div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</section>