<?php 
$about_section = get_theme_mod( 'martial_arts_training_pro_calender_enable' );
if ( 'Disable' == $about_section ) {
  return;
}
if( get_theme_mod('martial_arts_training_pro_calender_bgcolor') ) {
  $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_calender_bgcolor')).';';
}elseif( get_theme_mod('martial_arts_training_pro_calender_bgimage') ){
  $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_calender_bgimage')).'\')';
}else{
  $about_backg = '';
}

?>
<section id="calender" style="<?php echo esc_attr($about_backg); ?>">
	<div class="container">
		<div class="calender_head">
			<?php if(get_theme_mod('martial_arts_training_pro_calender_main_heading')!=''){ ?>
	            <h3 class="pb-0 m-0">
	              <?php echo esc_html(get_theme_mod('martial_arts_training_pro_calender_main_heading')); ?>
	            </h3>
	        <?php } ?>
	        <img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_calender_title_img')); ?>">
    	</div>
        <div class="calender_content mt-5">
        	<table class="table table-bordered">
			  <thead>
			    <tr>
			      <th class="icon"><i class="<?php echo get_theme_mod('martial_arts_training_pro_calender_icon');?>"></i></th>
			      <?php 
			      $time = get_theme_mod('martial_arts_training_pro_calender_time_count');
			      for($i=1;$i<=$time;$i++) { ?>
				      	<th scope="col" class="time"><?php echo get_theme_mod('martial_arts_training_pro_calender_weekend_time'.$i);?></th>
				  <?php }?>
			    </tr>
			  </thead>
			  <tbody>
			  	<?php for($i=1;$i<=7;$i++) { ?>
				    <tr>
				      <th scope="row" class="week"><?php echo get_theme_mod('martial_arts_training_pro_calender_weekend'.$i);?></th>
				      <?php 
				      $content = get_theme_mod('martial_arts_training_pro_calender_content_count'.$i);
				      for($j=1;$j<=$content;$j++) { ?>
				      	<td>
				      		<p class="title"><?php echo get_theme_mod('martial_arts_training_pro_calender_weekend_title'.$i.$j);?></p>
				      		<p class="text"><?php echo get_theme_mod('martial_arts_training_pro_calender_weekend_text'.$i.$j);?></p>
				      	</td>
				  	  <?php }?>
				    </tr>
				<?php } ?>
			  </tbody>
			</table>
        </div>
	</div>
</section>