<?php 
$about_section = get_theme_mod( 'martial_arts_training_pro_calculator_enable' );
if ( 'Disable' == $about_section ) {
  return;
}
if( get_theme_mod('martial_arts_training_pro_calculator_bgcolor') ) {
  $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_calculator_bgcolor')).';';
}elseif( get_theme_mod('martial_arts_training_pro_calculator_bgimage') ){
  $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_calculator_bgimage')).'\')';
}else{
  $about_backg = '';
}

?>
<section id="calculator" style="<?php echo esc_attr($about_backg); ?>">
	<div class="container">
		<div class="calculator-head">
			<div class="col-lg-12 col-md-12">
				<?php if(get_theme_mod('martial_arts_training_pro_calculator_main_heading')!=''){ ?>
		            <h3 class="pb-0 m-0">
		              <?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_main_heading')); ?>
		            </h3>
	            <?php } ?>
	            <img src="<?php echo esc_url(get_theme_mod('martial_arts_training_pro_calculator_title_img')); ?>">
			</div>
		</div>
		<div class="row mt-4">
			<div class="col-lg-7 col-md-7 col-12">
				<h5 class="title m-0"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_left_title')); ?></h5>
				<p class="post"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_left_text')); ?></p>
                <div class="form-horizontal" id="form">
                	<div class="row">
                		<div class="col-lg-6 col-12">
		                    <div class="form-group">
		                        <input type="text" class="form-control" id="height" placeholder="Height / Centimetre">
		                    </div>
                		</div>
		                <div class="col-lg-6 col-12">
		                    <div class="form-group">
		                        <input type="text" class="form-control" id="weight" placeholder="Weight / Kilogram ">
		                    </div>
		                </div>
                	</div>
                	<div class="row">
                		<div class="col-lg-4 col-12">
		                    <div class="form-group">
		                        <input type="number" class="form-control" id="age" placeholder="Age">
		                    </div>
                		</div>
		                <div class="col-lg-4 col-12">
		                    <div class="form-group">
		                        <select name="gender" id="gender" class="form-control">
								    <option value="Male" id="male">Male</option>
								    <option value="female" id="female">Female</option>
								</select>
		                    </div>
		                </div>
		                <div class="col-lg-4 col-12">
		                     <div class="form-group">
                        		<button type="submit" id="submit">Calculate</button>
                    		</div>
		                </div>
                	</div>
                </div>
                <div class="bmi_btn">
                	<a href="">Your BMI : <span id="calculate"></span></a>
                </div>
			</div>
			<div class="col-lg-5 col-md-5 col-12">
				<h5 class="list_title"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_right_title')); ?></h5>
				<ul class="">
					<div class="row">
						<div class="col-lg-6 col-6 p-0 list_box">
							<li class="head"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_left_heading')); ?></li>
							<?php for($i=1; $i<=4; $i++) { ?>
								<li>
									<?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_list_left'.$i)); ?>
								</li>
							<?php } ?>
						</div>
						<div class="col-lg-6 col-6 p-0 list_box">
							<li class="head"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_right_heading')); ?></li>
							<?php for($i=1; $i<=4; $i++) { ?>
								<li>
									<?php echo esc_html(get_theme_mod('martial_arts_training_pro_calculator_list_right'.$i)); ?>
								</li>
							<?php } ?>
						</div>
					</div>
				</ul>
			</div>
		</div>
	</div>
</section>	
