<?php
/**
 * Template part for displaying Top Bar Content
 *
 * @package martial-arts-training-pro
 */ 

$topbar_section = get_theme_mod( 'martial_arts_training_pro_topbar_enable' );
if ( 'Disable' == $topbar_section ) {
  return;
}
?>
<div id="topbar">
  <?php /*--Top Bar--*/
    if( get_theme_mod('martial_arts_training_pro_topbar_color') ) { 
      $about_backg = 'background-color:'.esc_attr(get_theme_mod('martial_arts_training_pro_topbar_color')).';';
    }elseif( get_theme_mod('martial_arts_training_pro_topbar_image') ){
      $about_backg = 'background-image:url(\''.esc_url(get_theme_mod('martial_arts_training_pro_topbar_image')).'\')';
    }else{
      $about_backg = '';       
    }
  ?>
  <div class="topbar_section">
    <div class="container">
      <div class="row">           
        <div class="col-lg-7 offset-lg-3 col-md-9 col-sm-12 col-12">
          <div class="topbar-content">
            <ul class="left-side-content">
              <?php if(get_theme_mod('martial_arts_training_pro_topbar_section_phone_title')!=''){ ?>
              <li class="title">
                <span class="hi_normal"><i class="<?php echo esc_html(get_theme_mod('martial_arts_training_pro_topbar_section_phone_icon')); ?>"></i> <?php echo esc_html(get_theme_mod('martial_arts_training_pro_topbar_section_phone_title')); ?></span>
              </li>
              <li class="number"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_topbar_section_phone_no')); ?></li>
              <?php } ?>
              <?php if(get_theme_mod('martial_arts_training_pro_topbar_section_email_title')!=''){ ?>
              <li class="title">
                <span class="hi_normal"><i class="<?php echo esc_html(get_theme_mod('martial_arts_training_pro_topbar_section_email_icon')); ?>"></i> <?php echo esc_html(get_theme_mod('martial_arts_training_pro_topbar_section_email_title')); ?></span>
              </li>
              <li class="number"><?php echo esc_html(get_theme_mod('martial_arts_training_pro_topbar_section_email_id')); ?></li>
              <?php } ?>
            </ul>
          </div>
        </div>
        <div class="col-lg-2 col-md-3 col-sm-12 col-12 social">
            <?php do_action( 'martial_arts_training_pro_before_header' ); 
              get_template_part('template-parts/home/social-icons'); 
            ?>
        </div> 
        <div class="clearfix"></div>
      </div>
    </div>
    <div class="clearfix"></div>
  </div>
</div>