<?php
/**
 * Template part for displaying header content
 *
 * @package martial_arts_training_pro
 */
?>
<div class="nav_wrap">
    <div class="main-header-box container">
      <div class="row bg-media">
        <div class="col-lg-3 col-md-8 col-sm-8 col-8 align-self-center">
          <div class="logo">
            <?php
           if( has_custom_logo() ){  martial_arts_training_pro_the_custom_logo();  } 
              $logo= get_theme_mod( 'custom_logo' );
              if($logo){ ?>
                <div class="logo-text">
                  <?php if( get_theme_mod('martial_arts_training_pro_display_title', true) != ''){ ?>
                    <h2><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_attr(bloginfo( 'name' )); ?></a></h2>
                  <?php }
                    if( get_theme_mod('martial_arts_training_pro_display_tagline', true) != ''){ 
                    $description = get_bloginfo( 'description', 'display' );
                    if ( $description || is_customize_preview() ) : ?>
                    <p>
                      <?php echo esc_html($description); ?>
                    </p>
                  <?php endif; } 
                  ?>
                </div>
            <?php } else { ?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/logo.png" alt="<?php bloginfo( 'name' ); ?>"/></a>  
            <?php }?>          
          </div>
        </div>
        <div class="col-lg-9 col-md-2 col-sm-4 col-4 header-nav">
          <?php get_template_part( 'template-parts/header/navigation' ); ?>
        </div>
      </div>
    </div>
  </div>
</div>