<?php

function martial_arts_training_pro_gettingstarted() {    	
	add_theme_page( esc_html__('Get Started', 'martial-arts-training-pro'), esc_html__('Get Started', 'martial-arts-training-pro'), 'edit_theme_options', 'martial_arts_training_pro_guide', 'martial_arts_training_pro_mostrar_guide');   
}
add_action( 'admin_menu', 'martial_arts_training_pro_gettingstarted' );

function martial_arts_training_pro_notice(){
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {?>
    <div class="notice notice-success is-dismissible getting_started">
		<div class="notice-content">
			<h2><?php echo esc_html( 'Thanks for installing Martial Arts Training Pro', 'martial-arts-training-pro' ) ?> </h2>
			<p><?php echo esc_html( 'Martial Arts Training Pro now supports colors, typography custom links for custom post types. Take benefit of a variety of features, functionalities, elements, and an exclusive set of customization options to build your own professional website', 'martial-arts-training-pro' ) ?></p>
			<p><?php echo esc_html( "Please Click on the link below to know the theme setup information", 'martial-arts-training-pro' ) ?></p>
			<p><a href="<?php echo esc_url( admin_url( 'themes.php?page=martial_arts_training_pro_guide' ) ); ?>" class="button button-primary get_btn"><?php echo esc_html( 'Get Started With Demo Importer', 'martial-arts-training-pro' ); ?></a></p>
		</div>
	</div>
	<?php }
}
add_action('admin_notices', 'martial_arts_training_pro_notice');

function martial_arts_training_pro_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', get_template_directory_uri() . '/inc/getstarted/getstart.css');
}
add_action('admin_enqueue_scripts', 'martial_arts_training_pro_admin_theme_style');

function martial_arts_training_pro_mostrar_guide() { 
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'martial-arts-training-pro' );
?>

<div class="wrapper-info">
	<h2><?php echo esc_html( 'Welcome to Martial Arts Training Pro', 'martial-arts-training-pro' ); ?> <span class="version"><?php echo esc_html( 'Version', 'martial-arts-training-pro' ); ?>: <?php echo esc_html($theme['Version']);?></span></h2>
	<p><?php echo esc_html('Before demo importer first install given plugins, Contact Form 7 and Woocommerce plugin then click on demo importer button to import all the demo contents.','martial-arts-training-pro'); ?></p>
	<?php require get_parent_theme_file_path( '/inc/getstarted/demo-importer.php' ); ?>
</div>

<?php } ?>