<?php
/**
 * martial-arts-training-pro Theme Customizer
 *
 * @package martial-arts-training-pro
 */
/**
 * Loads custom control for layout settings
 */
function martial_arts_training_pro_custom_controls() {
    require_once get_template_directory() . '/inc/admin/customize-texteditor-control.php';
    require_once get_template_directory() . '/inc/custom-controls.php';

     // Inlcude the Alpha Color Picker control file.
    require_once get_template_directory() . '/inc/alpha-color-picker.php';
    get_stylesheet_directory_uri() . '/assets/js/alpha-color-picker.js';
    get_stylesheet_directory_uri() . '/assets/css/alpha-color-picker.css';

    
}
add_action( 'customize_register', 'martial_arts_training_pro_custom_controls' );
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function martial_arts_training_pro_customize_register( $wp_customize ) {
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

    $wp_customize->selective_refresh->add_partial( 'blogname', array(
        'selector' => '.logo a',
        'render_callback' => 'twentyfifteen_customize_partial_blogname',
    ) );
    $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
        'selector' => '.site-description',
        'render_callback' => 'twentyfifteen_customize_partial_blogdescription',
    ) );

    $wp_customize->add_setting('martial_arts_training_pro_display_title',array(
        'default' => 'false',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('martial_arts_training_pro_display_title',array(
        'type' => 'checkbox',
        'label' => __('Show Title','martial-arts-training-pro'),
        'section' => 'title_tagline',
    ));
    $wp_customize->add_setting('martial_arts_training_pro_display_tagline',array(
        'default' => 'false',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('martial_arts_training_pro_display_tagline',array(
        'type' => 'checkbox',
        'label' => __('Show Tagline','martial-arts-training-pro'),
        'section' => 'title_tagline',
    ));
    
    //add home page setting pannel
    $wp_customize->add_panel( 'martial_arts_training_pro_panel_id', array(
        'priority' => 10,
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => __( 'Theme Settings', 'martial-arts-training-pro' ),
        'description' => __( 'Description of what this panel does.', 'martial-arts-training-pro' ),
    ) );
    $font_array = array(
        '' => __( 'No Fonts', 'martial-arts-training-pro' ),
        'Abril Fatface' => __( 'Abril Fatface', 'martial-arts-training-pro' ),
        'Acme' => __( 'Acme', 'martial-arts-training-pro' ),
        'Anton' => __( 'Anton', 'martial-arts-training-pro' ),
        'Architects Daughter' => __( 'Architects Daughter', 'martial-arts-training-pro' ),
        'Arimo' => __( 'Arimo', 'martial-arts-training-pro' ),
        'Arsenal' => __( 'Arsenal', 'martial-arts-training-pro' ),
        'Arvo' => __( 'Arvo', 'martial-arts-training-pro' ),
        'Alegreya' => __( 'Alegreya', 'martial-arts-training-pro' ),
        'Alfa Slab One' => __( 'Alfa Slab One', 'martial-arts-training-pro' ),
        'Averia Serif Libre' => __( 'Averia Serif Libre', 'martial-arts-training-pro' ),
        'Bangers' => __( 'Bangers', 'martial-arts-training-pro' ),
        'Boogaloo' => __( 'Boogaloo', 'martial-arts-training-pro' ),
        'Bad Script' => __( 'Bad Script', 'martial-arts-training-pro' ),
        'Bitter' => __( 'Bitter', 'martial-arts-training-pro' ),
        'Bree Serif' => __( 'Bree Serif', 'martial-arts-training-pro' ),
        'BenchNine' => __( 'BenchNine', 'martial-arts-training-pro' ),
        'Cabin' => __( 'Cabin', 'martial-arts-training-pro' ),
        'Cardo' => __( 'Cardo', 'martial-arts-training-pro' ),
        'Courgette' => __( 'Courgette', 'martial-arts-training-pro' ),
        'Cherry Swash' => __( 'Cherry Swash', 'martial-arts-training-pro' ),
        'Cormorant Garamond' => __( 'Cormorant Garamond', 'martial-arts-training-pro' ),
        'Crimson Text' => __( 'Crimson Text', 'martial-arts-training-pro' ),
        'Cuprum' => __( 'Cuprum', 'martial-arts-training-pro' ),
        'Cookie' => __( 'Cookie', 'martial-arts-training-pro' ),
        'Chewy' => __( 'Chewy', 'martial-arts-training-pro' ),
        'Days One' => __( 'Days One', 'martial-arts-training-pro' ),
        'Dosis' => __( 'Dosis', 'martial-arts-training-pro' ),
        'Economica' => __( 'Economica', 'martial-arts-training-pro' ),
        'Fredoka One' => __( 'Fredoka One', 'martial-arts-training-pro' ),
        'Fjalla One' => __( 'Fjalla One', 'martial-arts-training-pro' ),
        'Francois One' => __( 'Francois One', 'martial-arts-training-pro' ),
        'Frank Ruhl Libre' => __( 'Frank Ruhl Libre', 'martial-arts-training-pro' ),
        'Gloria Hallelujah' => __( 'Gloria Hallelujah', 'martial-arts-training-pro' ),
        'Great Vibes' => __( 'Great Vibes', 'martial-arts-training-pro' ),
        'Handlee' => __( 'Handlee', 'martial-arts-training-pro' ),
        'Hammersmith One' => __( 'Hammersmith One', 'martial-arts-training-pro' ),
        'Inconsolata' => __( 'Inconsolata', 'martial-arts-training-pro' ),
        'Indie Flower' => __( 'Indie Flower', 'martial-arts-training-pro' ),
        'IM Fell English SC' => __( 'IM Fell English SC', 'martial-arts-training-pro' ),
        'Julius Sans One' => __( 'Julius Sans One', 'martial-arts-training-pro' ),
        'Josefin Slab' => __( 'Josefin Slab', 'martial-arts-training-pro' ),
        'Josefin Sans' => __( 'Josefin Sans', 'martial-arts-training-pro' ),
        'Kanit' => __( 'Kanit', 'martial-arts-training-pro' ),
        'Lobster' => __( 'Lobster', 'martial-arts-training-pro' ),
        'Lato' => __( 'Lato', 'martial-arts-training-pro' ),
        'Lora' => __( 'Lora', 'martial-arts-training-pro' ),
        'Libre Baskerville' => __( 'Libre Baskerville', 'martial-arts-training-pro' ),
        'Lobster Two' => __( 'Lobster Two', 'martial-arts-training-pro' ),
        'Merriweather' => __( 'Merriweather', 'martial-arts-training-pro' ),
        'Monda' => __( 'Monda', 'martial-arts-training-pro' ),
        'Montserrat' => __( 'Montserrat', 'martial-arts-training-pro' ),
        'Muli' => __( 'Muli', 'martial-arts-training-pro' ),
        'Marck Script' => __( 'Marck Script', 'martial-arts-training-pro' ),
        'Noto Serif' => __( 'Noto Serif', 'martial-arts-training-pro' ),
        'Open Sans' => __( 'Open Sans', 'martial-arts-training-pro' ),
        'Overpass' => __( 'Overpass', 'martial-arts-training-pro' ),
        'Overpass Mono' => __( 'Overpass Mono', 'martial-arts-training-pro' ),
        'Oxygen' => __( 'Oxygen', 'martial-arts-training-pro' ),
        'Orbitron' => __( 'Orbitron', 'martial-arts-training-pro' ),
        'Patua One' => __( 'Patua One', 'martial-arts-training-pro' ),
        'Pacifico' => __( 'Pacifico', 'martial-arts-training-pro' ),
        'Padauk' => __( 'Padauk', 'martial-arts-training-pro' ),
        'Playball' => __( 'Playball', 'martial-arts-training-pro' ),
        'Playfair Display' => __( 'Playfair Display', 'martial-arts-training-pro' ),
        'PT Sans' => __( 'PT Sans', 'martial-arts-training-pro' ),
        'Philosopher' => __( 'Philosopher', 'martial-arts-training-pro' ),
        'Permanent Marker' => __( 'Permanent Marker', 'martial-arts-training-pro' ),
        'Poiret One' => __( 'Poiret One', 'martial-arts-training-pro' ),
        'Quicksand' => __( 'Quicksand', 'martial-arts-training-pro' ),
        'Quattrocento Sans' => __( 'Quattrocento Sans', 'martial-arts-training-pro' ),
        'Raleway' => __( 'Raleway', 'martial-arts-training-pro' ),
        'Rubik' => __( 'Rubik', 'martial-arts-training-pro' ),
        'Rokkitt' => __( 'Rokkitt', 'martial-arts-training-pro' ),
        'Russo One' => __( 'Russo One', 'martial-arts-training-pro' ),
        'Righteous' => __( 'Righteous', 'martial-arts-training-pro' ),
        'Slabo' => __( 'Slabo', 'martial-arts-training-pro' ),
        'Source Sans Pro' => __( 'Source Sans Pro', 'martial-arts-training-pro' ),
        'Shadows Into Light Two' => __( 'Shadows Into Light Two', 'martial-arts-training-pro'),
        'Shadows Into Light' => __( 'Shadows Into Light', 'martial-arts-training-pro' ),
        'Sacramento' => __( 'Sacramento', 'martial-arts-training-pro' ),
        'Shrikhand' => __( 'Shrikhand', 'martial-arts-training-pro' ),
        'Tangerine' => __( 'Tangerine', 'martial-arts-training-pro' ),
        'Ubuntu' => __( 'Ubuntu', 'martial-arts-training-pro' ),
        'VT323' => __( 'VT323', 'martial-arts-training-pro' ),
        'Varela Round' => __( 'Varela Round', 'martial-arts-training-pro' ),
        'Vampiro One' => __( 'Vampiro One', 'martial-arts-training-pro' ),
        'Vollkorn' => __( 'Vollkorn', 'martial-arts-training-pro' ),
        'Volkhov' => __( 'Volkhov', 'martial-arts-training-pro' ),
        'Yanone Kaffeesatz' => __( 'Yanone Kaffeesatz', 'martial-arts-training-pro' )
    );

    require_once get_template_directory() . '/inc/customizer-seperator/class/customizer-seperator.php';
    require_once get_template_directory() . '/inc/customizer-text-radio-button/class/customizer-text-radio-button.php';
    require get_template_directory() . '/inc/customize-repeater/customize-repeater.php';

    //general Settings
    require get_template_directory() . '/inc/customizer-custom-variables.php';
    //Header
    require get_template_directory() . '/inc/customizer-part-header.php';
    //Slider
    require get_template_directory() . '/inc/customizer-part-slide.php';
    //Home page sections
    require get_template_directory() . '/inc/customizer-part-home.php';
     //Social Icon
    require get_template_directory() . '/inc/customizer-part-social-icons.php';
    //Footer
    require get_template_directory() . '/inc/customizer-part-footer.php';
}
add_action( 'customize_register', 'martial_arts_training_pro_customize_register' );
//Integer
function martial_arts_training_pro_sanitize_integer( $input ) {
    if( is_numeric( $input ) ) {
        return intval( $input );
    }
}

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class martial_arts_training_pro_customize {
    /**
     * Returns the instance.
     *
     * @since  1.0.0
     * @access public
     * @return object
     */
    public static function get_instance() {
        static $instance = null;
        if ( is_null( $instance ) ) {
            $instance = new self;
            $instance->setup_actions();
        }
        return $instance;
    }

    /**
     * Constructor method.
     *
     * @since  1.0.0
     * @access private
     * @return void
     */
    private function __construct() {}

    /**
     * Sets up initial actions.
     *
     * @since  1.0.0
     * @access private
     * @return void
     */
    private function setup_actions() {
        // Register panels, sections, settings, controls, and partials.
        add_action( 'customize_register', array( $this, 'sections' ) );
        // Register scripts and styles for the controls.
        add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
    }

    /**
     * Sets up the customizer sections.
     *
     * @since  1.0.0
     * @access public
     * @param  object  $manager
     * @return void
     */
    public function sections( $manager ) {
        // Load custom sections.
        load_template( trailingslashit( get_template_directory() ) . '/inc/review-section.php' );

        // Register custom section types.
        $manager->register_section_type( 'martial_arts_training_pro_customize_reviews_and_testimonials' );

        // Register review and testimonial section.
        $manager->add_section(
            new martial_arts_training_pro_customize_reviews_and_testimonials(
                $manager,
                'example_1',
                array(
                    'title'    => esc_html__( 'Review & Testimonial', 'martial-arts-training-pro' ),
                    'reviews_and_testimonials_text' => esc_html__( 'Rate Us', 'martial-arts-training-pro' ),
                    'reviews_and_testimonials_url'  => 'https://www.ovationthemes.com/topic/reviews-and-testimonials/',
                    'priority' => '1',
                    'section_class' => 'review-testimonial-section' // Add a unique CSS class for this section
                )
            )
        );

        // Register bundle link section.
        $manager->add_section(
            new martial_arts_training_pro_customize_reviews_and_testimonials(
                $manager,
                'bundle_link_section',
                array(
                    'title'    => esc_html__( 'WordPress Theme Bundle - Get All Our Themes In Single Package At Just $89', 'adventure-trekking-camp-pro' ),
                    'reviews_and_testimonials_text' => esc_html__( 'Get Bundle', 'adventure-trekking-camp-pro' ),
                    'reviews_and_testimonials_url'  => 'https://www.ovationthemes.com/products/wordpress-bundle',
                    'priority' => '0',
                    'section_class' => 'bundle-link-section' // Add a unique CSS class for this section
                )
            )
        );
    }

    /**
     * Loads theme customizer CSS.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function enqueue_control_scripts() {
        wp_enqueue_script( 'martial-arts-training-pro-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );
        wp_enqueue_style( 'martial-arts-training-pro-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
    }
}

// Ensure the customizer class is loaded.
martial_arts_training_pro_customize::get_instance();