<?php
	$wp_customize->add_section('martial_arts_training_pro_slider_section',array(
		'title'	=> __('Slider Settings','martial-arts-training-pro'),
		'description'	=> __('Add slider images here.','martial-arts-training-pro'),
		'priority'	=> null,
		'panel' => 'martial_arts_training_pro_panel_id',
	));
    $wp_customize->add_setting( 'martial_arts_training_pro_slider_enabledisable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_slider_enabledisable',
    array(
      'label' => esc_html__( 'Show or Hide Slider Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_slider_section'
	)));

    $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_slider_enabledisable', array(
	    'selector' => '.slider-box',
	    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_slider_enabledisable',
	));

	$wp_customize->add_setting('martial_arts_training_pro_slide_number',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('martial_arts_training_pro_slide_number',array(
		'label'	=> __('Number of slides to show','martial-arts-training-pro'),
		'section'	=> 'martial_arts_training_pro_slider_section',
		'type'		=> 'number'
	));
	$count =  get_theme_mod('martial_arts_training_pro_slide_number');
		
	for($i=1; $i<=$count; $i++ ) {

		$wp_customize->add_setting( 'martial_arts_training_pro_slider_section_settings'.$i,
		    array(
		    'default' => '',
		    'transport' => 'postMessage',
		    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
		 ));
		 $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_slider_section_settings'.$i,
		    array(
		    'label' => __('Slider Settings ','martial-arts-training-pro').$i,
		    'section' => 'martial_arts_training_pro_slider_section'
		)));

		$wp_customize->add_setting('martial_arts_training_pro_slide_image'.$i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'esc_url_raw',
		));
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_slide_image'.$i,
	        array(
            'label' => __('Slider Image ','martial-arts-training-pro').$i.__(' (1600x562)','martial-arts-training-pro'),
            'section' => 'martial_arts_training_pro_slider_section',
            'settings' => 'martial_arts_training_pro_slide_image'.$i
		)));
		
		$wp_customize->add_setting('martial_arts_training_pro_slide_heading1'.$i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_text_field',
		));
		$wp_customize->add_control('martial_arts_training_pro_slide_heading1'.$i,array(
			'label' => __('Slide Heading1','martial-arts-training-pro').$i,
			'section' => 'martial_arts_training_pro_slider_section',
			'setting'	=> 'martial_arts_training_pro_slide_heading1'.$i,
			'type'	=> 'text'
		));

		$wp_customize->add_setting('martial_arts_training_pro_slide_heading2'.$i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_text_field',
		));
		$wp_customize->add_control('martial_arts_training_pro_slide_heading2'.$i,array(
			'label' => __('Slide Heading2','martial-arts-training-pro').$i,
			'section' => 'martial_arts_training_pro_slider_section',
			'setting'	=> 'martial_arts_training_pro_slide_heading2'.$i,
			'type'	=> 'text'
		));

		$wp_customize->add_setting('martial_arts_training_pro_slide_text'.$i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_textarea_field',
		));
		$wp_customize->add_control('martial_arts_training_pro_slide_text'.$i,array(
			'label' => __('Slide Text','martial-arts-training-pro').$i,
			'section' => 'martial_arts_training_pro_slider_section',
			'setting'	=> 'martial_arts_training_pro_slide_text'.$i,
			'type'	=> 'text'
		));
		$wp_customize->add_setting('martial_arts_training_pro_slide_btn'.$i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_textarea_field',
		));
		$wp_customize->add_control('martial_arts_training_pro_slide_btn'.$i,array(
			'label' => __('Slide Button','martial-arts-training-pro').$i,
			'section' => 'martial_arts_training_pro_slider_section',
			'setting'	=> 'martial_arts_training_pro_slide_btn'.$i,
			'type'	=> 'text'
		));
		$wp_customize->add_setting('martial_arts_training_pro_slide_btn_url'.$i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_textarea_field',
		));
		$wp_customize->add_control('martial_arts_training_pro_slide_btn_url'.$i,array(
			'label' => __('Slide Button Url','martial-arts-training-pro').$i,
			'section' => 'martial_arts_training_pro_slider_section',
			'setting'	=> 'martial_arts_training_pro_slide_btn_url'.$i,
			'type'	=> 'text'
		));
	}

	// Other Settings
	$wp_customize->add_setting('martial_arts_training_pro_slide_delay',array(
		'default'	=> '1000',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('martial_arts_training_pro_slide_delay',array(
		'label'	=> __('Slide Delay','martial-arts-training-pro'),
		'section'	=> 'martial_arts_training_pro_slider_section',
		'description' => __('interval is in milliseconds. 1000 = 1 second -> so 1000 * 10 = 10 seconds', 'martial-arts-training-pro'),
		'type'		=> 'number'
	));
	$wp_customize->add_setting( 'martial_arts_training_pro_slider_arrows',
   array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
   	));
 
  	$wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_slider_arrows',
     array(
        'label' => esc_html__( 'Show/Hide Slider Nav', 'martial-arts-training-pro' ),
        'section' => 'martial_arts_training_pro_slider_section'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_slider_section_color_setting',
		    array(
		    'default' => '',
		    'transport' => 'postMessage',
		    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
	 ));
	 $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_slider_section_color_setting',
	    array(
	    'label' => __('Slider Color Settings ','martial-arts-training-pro'),
	    'section' => 'martial_arts_training_pro_slider_section'
	)));

	// This is Slider Heading Color picker setting
	$wp_customize->add_setting( 'martial_arts_training_pro_sliderHeading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_sliderHeading_color', array(
		'label' => __('Slider Heading Color', 'martial-arts-training-pro'),
		'section' => 'martial_arts_training_pro_slider_section',
		'settings' => 'martial_arts_training_pro_sliderHeading_color',
	)));
	//This is Slider Heading FontFamily picker setting
	$wp_customize->add_setting('martial_arts_training_pro_sliderHeading_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'martial_arts_switch_sanitization'
	));
	$wp_customize->add_control(
	    'martial_arts_training_pro_sliderHeading_font_family', array(
	    'section'  => 'martial_arts_training_pro_slider_section',
	    'label'    => __( 'Slider Heading Fonts','martial-arts-training-pro'),
	    'type'     => 'select',
	    'choices'  => $font_array,
	));
	// This is Slider Text Color picker setting
	$wp_customize->add_setting( 'martial_arts_training_pro_slidertext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_slidertext_color', array(
		'label' => __('Slider Text Color', 'martial-arts-training-pro'),
		'section' => 'martial_arts_training_pro_slider_section',
		'settings' => 'martial_arts_training_pro_slidertext_color',
	)));
	//This is Slider Text FontFamily picker setting
	$wp_customize->add_setting('martial_arts_training_pro_slidertext_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'martial_arts_switch_sanitization'
	));
	$wp_customize->add_control(
	    'martial_arts_training_pro_slidertext_font_family', array(
	    'section'  => 'martial_arts_training_pro_slider_section',
	    'label'    => __( 'Slider Text Fonts','martial-arts-training-pro'),
	    'type'     => 'select',
	    'choices'  => $font_array,
	));

	$wp_customize->add_setting( 'martial_arts_training_pro_slider_btn_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_slider_btn_color', array(
		'label' => __('Slider Button Color', 'martial-arts-training-pro'),
		'section' => 'martial_arts_training_pro_slider_section',
		'settings' => 'martial_arts_training_pro_slider_btn_color',
	)));
	$wp_customize->add_setting('martial_arts_training_pro_slider_btn_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'martial_arts_switch_sanitization'
	));
	$wp_customize->add_control(
	    'martial_arts_training_pro_slider_btn_font_family', array(
	    'section'  => 'martial_arts_training_pro_slider_section',
	    'label'    => __( 'Slider Button Fonts','martial-arts-training-pro'),
	    'type'     => 'select',
	    'choices'  => $font_array,
	));

	$wp_customize->add_setting( 'martial_arts_training_pro_slider_nav_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_slider_nav_color', array(
		'label' => __('Slider Nav Color', 'martial-arts-training-pro'),
		'section' => 'martial_arts_training_pro_slider_section',
		'settings' => 'martial_arts_training_pro_slider_nav_color',
	)));
	$wp_customize->add_setting('martial_arts_training_pro_slider_nav_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'martial_arts_switch_sanitization'
	));
	$wp_customize->add_control(
	    'martial_arts_training_pro_slider_nav_font_family', array(
	    'section'  => 'martial_arts_training_pro_slider_section',
	    'label'    => __( 'Slider Nav Fonts','martial-arts-training-pro'),
	    'type'     => 'select',
	    'choices'  => $font_array,
	));
	$wp_customize->add_setting( 'martial_arts_training_pro_slider_nav_bgcolor', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_slider_nav_bgcolor', array(
		'label' => __('Slider Nav Background', 'martial-arts-training-pro'),
		'section' => 'martial_arts_training_pro_slider_section',
		'settings' => 'martial_arts_training_pro_slider_nav_bgcolor',
	)));
?>