<?php         
  /* ----------------------- About  ---------------------- */

  $wp_customize->add_section('martial_arts_training_pro_about',array(
    'title' => __('About','martial-arts-training-pro'),
    'description' => __('Add About Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_about_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_about_enable',
    array(
      'label' => esc_html__( 'Show or Hide About Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_about'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_about_enable', array(
    'selector' => '#about .container-fluid',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_about_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_about_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_about_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_about'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_about_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_about_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_about',
    'settings' => 'martial_arts_training_pro_about_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_about_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_about_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimension 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_about',
    'settings' => 'martial_arts_training_pro_about_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_about_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_about_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_about'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_about_increase',array(
    'default' => '4',
    'sanitize_callback' => 'martial_arts_training_pro_sanitize_number_absint'
  ));
  $wp_customize->add_control('martial_arts_training_pro_about_increase',array(
    'label' => __('No of about to Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_about',
    'setting' => 'martial_arts_training_pro_about_increase',
    'type'    => 'number'
  )); 
  $about_number=get_theme_mod('martial_arts_training_pro_about_increase');
  for($i=1; $i<=$about_number; $i++) {    

    $wp_customize->add_setting('martial_arts_training_pro_about_image'.$i,array(
      'default' => '',
      'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_about_image'.$i,
          array(
            'label' => __('About Background Image ','martial-arts-training-pro').$i,
            'description' => __('Dimention 337 * 205','martial-arts-training-pro'),
            'section' => 'martial_arts_training_pro_about',
            'settings' => 'martial_arts_training_pro_about_image'.$i
    )));
    
    $wp_customize->add_setting('martial_arts_training_pro_about_heading'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_about_heading'.$i,array(
      'label' => __('About Title ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_about',
      'setting' => 'martial_arts_training_pro_about_heading'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_about_text'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_about_text'.$i,array(
      'label' => __('About Text ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_about',
      'setting' => 'martial_arts_training_pro_about_text'.$i,
      'type'  => 'textarea'
    ));

    $wp_customize->add_setting('martial_arts_training_pro_about_btn'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_about_btn'.$i,array(
      'label' => __('About Button ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_about',
      'setting' => 'martial_arts_training_pro_about_btn'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_about_btn_url'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_about_btn_url'.$i,array(
      'label' => __('About Button Url ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_about',
      'setting' => 'martial_arts_training_pro_about_btn_url'.$i,
      'type'  => 'text'
    ));
  }
  $wp_customize->add_setting( 'martial_arts_training_pro_about_color_settings',
      array(
      'default' => '',
      'transport' => 'postMessage',
      'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_about_color_settings',
        array(
        'label' => __('About Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_about'
    )));
   
   $wp_customize->add_setting( 'martial_arts_training_pro_about_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_about_title_color', array(
      'label' => __('About Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_about',
      'settings' => 'martial_arts_training_pro_about_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_about_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_about_title_font_family', array(
        'section'  => 'martial_arts_training_pro_about',
        'label'    => __( 'About Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_about_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_about_text_color', array(
      'label' => __('About Text Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_about',
      'settings' => 'martial_arts_training_pro_about_text_color',
    )));
    //This is Slider Text FontFamily picker setting
    $wp_customize->add_setting('martial_arts_training_pro_about_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_about_text_font_family', array(
        'section'  => 'martial_arts_training_pro_about',
        'label'    => __( 'About Text Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_about_btn_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_about_btn_color', array(
      'label' => __('About Button Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_about',
      'settings' => 'martial_arts_training_pro_about_btn_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_about_btn_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_about_btn_font_family', array(
        'section'  => 'martial_arts_training_pro_about',
        'label'    => __( 'About Button Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_about_btn_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_about_btn_bgcolor', array(
      'label' => __('About Button Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_about',
      'settings' => 'martial_arts_training_pro_about_btn_bgcolor',
    )));
  

    $wp_customize->add_setting( 'martial_arts_training_pro_about_bg_hover_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_about_bg_hover_color', array(
      'label' => __('About Background Hover Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_about',
      'settings' => 'martial_arts_training_pro_service_bg_hover_color',
    )));

// ---------------Services-----------------
  $wp_customize->add_section('martial_arts_training_pro_service',array(
    'title' => __('Service','martial-arts-training-pro'),
    'description' => __('Add Service Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_service_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_service_enable',
    array(
      'label' => esc_html__( 'Show or Hide Service Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_service'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_service_enable', array(
    'selector' => '#service .container-fluid',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_service_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_service_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_service_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_service'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_service_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_service_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_service',
    'settings' => 'martial_arts_training_pro_service_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_service_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_service_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimension 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_service',
    'settings' => 'martial_arts_training_pro_service_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_service_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_service_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_service'
  )));

  for($i=1; $i<=4; $i++) {

    $wp_customize->add_setting('martial_arts_training_pro_service_bgimage'.$i,array(
      'default' => '',
      'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_service_bgimage'.$i,
          array(
            'label' => __('Service Background Image ','martial-arts-training-pro').$i,
            'description' => __('Dimention 337 * 205','martial-arts-training-pro'),
            'section' => 'martial_arts_training_pro_service',
            'settings' => 'martial_arts_training_pro_service_bgimage'.$i
    )));
    $wp_customize->add_setting('martial_arts_training_pro_service_icon'.$i,array(
      'default' => '',
      'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_service_icon'.$i,
          array(
            'label' => __('Service Icon Image ','martial-arts-training-pro').$i,
            'description' => __('Dimention 78 * 62','martial-arts-training-pro'),
            'section' => 'martial_arts_training_pro_service',
            'settings' => 'martial_arts_training_pro_service_icon'.$i
    )));
    $wp_customize->add_setting('martial_arts_training_pro_service_heading'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_service_heading'.$i,array(
      'label' => __('Service Title ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_service',
      'setting' => 'martial_arts_training_pro_service_heading'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_service_text'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_service_text'.$i,array(
      'label' => __('Service Text ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_service',
      'setting' => 'martial_arts_training_pro_service_text'.$i,
      'type'  => 'textarea'
    ));
  }
  $wp_customize->add_setting( 'martial_arts_training_pro_service_color_settings',
      array(
      'default' => '',
      'transport' => 'postMessage',
      'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_service_color_settings',
        array(
        'label' => __('Services Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_service'
    )));
   
   $wp_customize->add_setting( 'martial_arts_training_pro_service_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_service_title_color', array(
      'label' => __('Service Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_service',
      'settings' => 'martial_arts_training_pro_service_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_service_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_service_title_font_family', array(
        'section'  => 'martial_arts_training_pro_service',
        'label'    => __( 'Service Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_service_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_service_text_color', array(
      'label' => __('Service Text Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_service',
      'settings' => 'martial_arts_training_pro_service_text_color',
    )));
    //This is Slider Text FontFamily picker setting
    $wp_customize->add_setting('martial_arts_training_pro_service_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_service_text_font_family', array(
        'section'  => 'martial_arts_training_pro_service',
        'label'    => __( 'Service Text Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_service_bg_hover_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_service_bg_hover_color', array(
      'label' => __('Service Background Hover Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_service',
      'settings' => 'martial_arts_training_pro_service_bg_hover_color',
    )));

  // -------------- Calculator ----------------

  $wp_customize->add_section('martial_arts_training_pro_calculator',array(
    'title' => __('Calculator','martial-arts-training-pro'),
    'description' => __('Add Calculator Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_calculator_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_calculator_enable',
    array(
      'label' => esc_html__( 'Show or Hide Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_calculator'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_calculator_enable', array(
    'selector' => '#calculator .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_calculator_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_calculator_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_calculator_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_calculator_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'settings' => 'martial_arts_training_pro_calculator_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_calculator_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_calculator_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'settings' => 'martial_arts_training_pro_calculator_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_calculator_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_calculator_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_calculator_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calculator_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'setting' => 'martial_arts_training_pro_calculator_main_heading',
    'type'    => 'text'
  )); 

  $wp_customize->add_setting('martial_arts_training_pro_calculator_left_title',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calculator_left_title',array(
    'label' => __('Left Title','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'setting' => 'martial_arts_training_pro_calculator_left_title',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_calculator_left_text',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calculator_left_text',array(
    'label' => __('Left Text','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'setting' => 'martial_arts_training_pro_calculator_left_text',
    'type'    => 'textarea'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_calculator_right_title',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calculator_right_title',array(
    'label' => __('Right Title','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'setting' => 'martial_arts_training_pro_calculator_right_title',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_calculator_left_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calculator_left_heading',array(
    'label' => __('List left Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'setting' => 'martial_arts_training_pro_calculator_left_heading',
    'type'    => 'text'
  )); 
  $wp_customize->add_setting('martial_arts_training_pro_calculator_right_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calculator_right_heading',array(
    'label' => __('List Right Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calculator',
    'setting' => 'martial_arts_training_pro_calculator_right_heading',
    'type'    => 'text'
  )); 
  for( $i=1; $i<=4; $i++ ) {
    $wp_customize->add_setting('martial_arts_training_pro_calculator_list_left'.$i,array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('martial_arts_training_pro_calculator_list_left'.$i,array(
      'label' => __('List Title ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_calculator',
      'setting' => 'martial_arts_training_pro_calculator_list_left'.$i,
      'type'    => 'text'
    )); 
    $wp_customize->add_setting('martial_arts_training_pro_calculator_list_right'.$i,array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('martial_arts_training_pro_calculator_list_right'.$i,array(
      'label' => __('List Text ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_calculator',
      'setting' => 'martial_arts_training_pro_calculator_list_right'.$i,
      'type'    => 'text'
    )); 
  }
  $wp_customize->add_setting( 'martial_arts_training_pro_calculator_color_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_calculator_color_settings',
        array(
        'label' => __('Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_calculator'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_main_heading_color', array(
      'label' => __('Calculator Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_main_heading_color',
    )));
   $wp_customize->add_setting('martial_arts_training_pro_calculator_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calculator_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_calculator',
        'label'    => __( 'Calculator Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
   $wp_customize->add_setting( 'martial_arts_training_pro_calculator_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_title_color', array(
      'label' => __('Calculator Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_calculator_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calculator_title_font_family', array(
        'section'  => 'martial_arts_training_pro_calculator',
        'label'    => __( 'Calculator Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_text_color', array(
      'label' => __('Calculator Text Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_text_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_calculator_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calculator_text_font_family', array(
        'section'  => 'martial_arts_training_pro_calculator',
        'label'    => __( 'Calculator Text Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_button_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_button_color', array(
      'label' => __('Calculator Button Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_button_color',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_button_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_button_bgcolor', array(
      'label' => __('Calculator Button Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_button_bgcolor',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_button_border', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_button_border', array(
      'label' => __('Calculator Button Border', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_button_border',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_bmi_btn_border', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_bmi_btn_border', array(
      'label' => __('BMI Button Border Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_bmi_btn_border',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_list_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_list_title_color', array(
      'label' => __('List Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_list_title_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_calculator_list_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calculator_list_title_font_family', array(
        'section'  => 'martial_arts_training_pro_calculator',
        'label'    => __( 'List Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_list_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_list_text_color', array(
      'label' => __('List Text Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_list_text_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_calculator_list_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calculator_list_text_font_family', array(
        'section'  => 'martial_arts_training_pro_calculator',
        'label'    => __( 'List Text Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_calculator_list_box_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calculator_list_box_bgcolor', array(
      'label' => __('Right Box Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calculator',
      'settings' => 'martial_arts_training_pro_calculator_list_box_bgcolor',
    )));

  // -------------- Trainer -----------------

  $wp_customize->add_section('martial_arts_training_pro_trainer',array(
    'title' => __('Trainer','martial-arts-training-pro'),
    'description' => __('Add Trainer Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_trainer_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_trainer_enable',
    array(
      'label' => esc_html__( 'Show or Hide Trainer Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_trainer'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_trainer_enable', array(
    'selector' => '#trainer .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_trainer_enable',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_trainer_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_trainer_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_trainer'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_trainer_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_trainer',
    'settings' => 'martial_arts_training_pro_trainer_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_trainer_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_trainer_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_trainer',
    'settings' => 'martial_arts_training_pro_trainer_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_trainer_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_trainer_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_trainer'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_trainer_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_trainer_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_trainer',
    'setting' => 'martial_arts_training_pro_trainer_main_heading',
    'type'    => 'text'
  )); 
  $wp_customize->add_setting('martial_arts_training_pro_trainer_slider_number',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_trainer_slider_number',array(
    'label' => __('No Of Trainer To Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_trainer',
    'setting' => 'martial_arts_training_pro_trainer_slider_number',
    'type'    => 'number'
  )); 
  $trainer=get_theme_mod('martial_arts_training_pro_trainer_slider_number');

  for($i=1; $i<=$trainer; $i++) {

    $wp_customize->add_setting('martial_arts_training_pro_trainer_image'.$i,array(
      'default' => '',
      'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_trainer_image'.$i,
          array(
            'label' => __('Trainer Image ','martial-arts-training-pro').$i,
            'section' => 'martial_arts_training_pro_trainer',
            'settings' => 'martial_arts_training_pro_trainer_image'.$i
    )));
    $wp_customize->add_setting('martial_arts_training_pro_tranier_title'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_tranier_title'.$i,array(
      'label' => __('Trainer Title','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_trainer',
      'setting' => 'martial_arts_training_pro_tranier_title'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_trainer_name'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_trainer_name'.$i,array(
      'label' => __('Trainer Name','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_trainer',
      'setting' => 'martial_arts_training_pro_trainer_name'.$i,
      'type'  => 'text'
    ));
  }
  $wp_customize->add_setting( 'martial_arts_training_pro_trainer_color_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_trainer_color_settings',
        array(
        'label' => __('Trainer Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_trainer'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_trainer_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_main_heading_color', array(
      'label' => __('Trainer Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_main_heading_color',
    )));
   
   $wp_customize->add_setting('martial_arts_training_pro_trainer_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_trainer_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_trainer',
        'label'    => __( 'Trainer Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
   $wp_customize->add_setting( 'martial_arts_training_pro_trainer_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_title_color', array(
      'label' => __('Trainer Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_trainer_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_trainer_title_font_family', array(
        'section'  => 'martial_arts_training_pro_trainer',
        'label'    => __( 'Trainer Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_trainer_name_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_name_color', array(
      'label' => __('Trainer Text Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_name_color',
    )));

   
    $wp_customize->add_setting('martial_arts_training_pro_trainer_name_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_trainer_name_font_family', array(
        'section'  => 'martial_arts_training_pro_trainer',
        'label'    => __( 'Trainer Text Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_trainer_fbicon_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_fbicon_color', array(
      'label' => __('Trainer Facebook Icon Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_fbicon_color',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_trainer_twicon_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_twicon_color', array(
      'label' => __('Trainer Twitter Icon Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_twicon_color',
    ))); 
    $wp_customize->add_setting( 'martial_arts_training_pro_trainer_youicon_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_youicon_color', array(
      'label' => __('Trainer Youtube Icon Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_youicon_color',
    ))); 
    $wp_customize->add_setting( 'martial_arts_training_pro_trainer_picon_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_trainer_picon_color', array(
      'label' => __('Trainer Pinterest Icon Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_trainer',
      'settings' => 'martial_arts_training_pro_trainer_picon_color',
    )));

  // -------------- Pricing plan ------------

  $wp_customize->add_section('martial_arts_training_pro_pricing',array(
    'title' => __('Pricing Plan','martial-arts-training-pro'),
    'description' => __('Add Pricing Plan Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_pricing_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
  $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_pricing_enable',
    array(
      'label' => esc_html__( 'Show or Hide Pricing Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_pricing'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_pricing_enable', array(
    'selector' => '#pricing .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_pricing_enable',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_pricing_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_pricing_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_pricing'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_pricing_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_pricing',
    'settings' => 'martial_arts_training_pro_pricing_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_pricing_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_pricing_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_pricing',
    'settings' => 'martial_arts_training_pro_pricing_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_pricing_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_pricing_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_pricing'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_pricing_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_pricing_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_pricing',
    'setting' => 'martial_arts_training_pro_pricing_main_heading',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_pricing_number',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
  ));
  $wp_customize->add_control('martial_arts_training_pro_pricing_number',array(
    'label' => __('No Of Pricing Plan To Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_pricing',
    'setting' => 'martial_arts_training_pro_pricing_number',
    'type'  => 'number'
  ));
  $pricing = get_theme_mod("martial_arts_training_pro_pricing_number");
  for($i=1; $i<=$pricing; $i++) {

    $wp_customize->add_setting('martial_arts_training_pro_pricing_plan'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_plan'.$i,array(
      'label' => __('Pricing Plan Title ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_plan'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_currency'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_currency'.$i,array(
      'label' => __('Pricing Plan Currency ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_currency'.$i,
      'type'  => 'text'
    ));  
    $wp_customize->add_setting('martial_arts_training_pro_pricing_price'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_price'.$i,array(
      'label' => __('Pricing Plan Price ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_price'.$i,
      'type'  => 'text'
    )); 
    $wp_customize->add_setting('martial_arts_training_pro_pricing_month'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_month'.$i,array(
      'label' => __('Pricing Plan Month ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_month'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_free'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_free'.$i,array(
      'label' => __('Pricing Plan Text ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_free'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_feature1'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_feature1'.$i,array(
      'label' => __('Pricing Plan List 1 ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_feature1'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_feature2'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_feature2'.$i,array(
      'label' => __('Pricing Plan List 2 ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_feature2'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_feature3'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_feature3'.$i,array(
      'label' => __('Pricing Plan List 3 ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_feature3'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_feature4'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_feature4'.$i,array(
      'label' => __('Pricing Plan List 4 ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_feature4'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_feature5'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_feature5'.$i,array(
      'label' => __('Pricing Plan List 5 ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_feature5'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_btn'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_btn'.$i,array(
      'label' => __('Pricing Button ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_btn'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_btn_url'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_pricing_btn_url'.$i,array(
      'label' => __('Pricing Button Url ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_pricing',
      'setting' => 'martial_arts_training_pro_pricing_btn_url'.$i,
      'type'  => 'text'
    ));
  }

  $wp_customize->add_setting( 'martial_arts_training_pro_pricing_color_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_pricing_color_settings',
        array(
        'label' => __('Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_pricing'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_main_heading_color', array(
      'label' => __('Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_main_heading_color',
    )));
   $wp_customize->add_setting('martial_arts_training_pro_pricing_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_pricing_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_pricing',
        'label'    => __( 'Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_title_color', array(
      'label' => __('Pricing Plan Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_pricing_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_pricing_title_font_family', array(
        'section'  => 'martial_arts_training_pro_pricing',
        'label'    => __( 'Pricing Plan Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_price_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_price_color', array(
      'label' => __('Pricing Plan Price Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_price_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_pricing_price_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_pricing_price_font_family', array(
        'section'  => 'martial_arts_training_pro_pricing',
        'label'    => __( 'Pricing Plan Price Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_trial_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_trial_color', array(
      'label' => __('Pricing Plan Trial Day Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_trial_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_pricing_trial_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_pricing_trial_font_family', array(
        'section'  => 'martial_arts_training_pro_pricing',
        'label'    => __( 'Pricing Plan Trial Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_trial_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_trial_bgcolor', array(
      'label' => __('Pricing Plan Trial Day Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_trial_bgcolor',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_text_color', array(
      'label' => __('Pricing Plan List Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_text_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_pricing_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_pricing_text_font_family', array(
        'section'  => 'martial_arts_training_pro_pricing',
        'label'    => __( 'Pricing Plan List Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_btn_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_btn_color', array(
      'label' => __('Pricing Plan Button Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_btn_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_pricing_btn_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_pricing_btn_font_family', array(
        'section'  => 'martial_arts_training_pro_pricing',
        'label'    => __( 'Pricing Plan Button Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_pricing_btn_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_pricing_btn_bgcolor', array(
      'label' => __('Pricing Plan Button Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_pricing',
      'settings' => 'martial_arts_training_pro_pricing_btn_bgcolor',
    )));
  
  // -------------- Gallery -----------------

  $wp_customize->add_section('martial_arts_training_pro_gallery',array(
    'title' => __('Gallery','martial-arts-training-pro'),
    'description' => __('Add Gallery Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_gallery_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_gallery_enable',
    array(
      'label' => esc_html__( 'Show or Hide Gallery Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_gallery'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_gallery_enable', array(
    'selector' => '#gallery .box1',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_gallery_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_gallery_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_gallery_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_gallery'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_gallery_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_gallery_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_gallery',
    'settings' => 'martial_arts_training_pro_gallery_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_gallery_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_gallery_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_gallery',
    'settings' => 'martial_arts_training_pro_gallery_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_gallery_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_gallery_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_gallery'
  )));
  
  for($i=1; $i<=13; $i++) {

    $wp_customize->add_setting('martial_arts_training_pro_gallery_image'.$i,array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(
      new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_gallery_image'.$i,array(
      'label' => __('Gallery Image ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_gallery',
      'settings' => 'martial_arts_training_pro_gallery_image'.$i
    )));
    $wp_customize->add_setting('martial_arts_training_pro_gallery_title'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_gallery_title'.$i,array(
      'label' => __('Gallery Title ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_gallery',
      'setting' => 'martial_arts_training_pro_gallery_title'.$i,
      'type'  => 'text'
    ));  
    $wp_customize->add_setting('martial_arts_training_pro_gallery_text'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_gallery_text'.$i,array(
      'label' => __('Gallery Text ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_gallery',
      'setting' => 'martial_arts_training_pro_gallery_text'.$i,
      'type'  => 'text'
    ));  
  }
  
  // -------------- Product ------------

  $wp_customize->add_section('martial_arts_training_pro_product',array(
    'title' => __('Product','martial-arts-training-pro'),
    'description' => __('Add Product Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_product_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_product_enable',
    array(
      'label' => esc_html__( 'Show or Hide Product Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_product'
  )));
  if ( !class_exists( 'WooCommerce' ) ) {
    $wp_customize->add_setting( 'martial_arts_training_pro_pro_tab_woo_msg',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_pro_tab_woo_msg',
    array(
      'label' => esc_html__( 'Show or Hide Woo-Message', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_product'
    )));
  }
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_product_enable', array(
    'selector' => '#product .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_product_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_product_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_product_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_product_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product',
    'settings' => 'martial_arts_training_pro_product_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_product_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_product_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product',
    'settings' => 'martial_arts_training_pro_product_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_product_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_product_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_product_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_product_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product',
    'setting' => 'martial_arts_training_pro_product_main_heading',
    'type'    => 'text'
  ));
  $args = array(
    'type'                     => 'product',
    'child_of'                 => 0,
    'parent'                   => '',
    'orderby'                  => 'term_group',
    'order'                    => 'ASC',
    'hide_empty'               => false,
    'hierarchical'             => 1,
    'number'                   => '',
    'taxonomy'                 => 'product_cat',
    'pad_counts'               => false
  );
  $categories = get_categories( $args );
  $cats = array();
  $i = 0;
  foreach($categories as $category){
    $cats[$category->slug] = $category->name;
  }
  $wp_customize->add_setting('martial_arts_training_pro_product_category',array(
        'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('martial_arts_training_pro_product_category',array(
        'type'    => 'select',
        'choices' => $cats,
        'label' => __('Select Product Category','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_product',
  ));
  $wp_customize->add_setting('martial_arts_training_pro_product_number',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_product_number',array(
    'label' => __('No of Product To Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product',
    'setting' => 'martial_arts_training_pro_product_number',
    'type'    => 'number'
  )); 
  $wp_customize->add_setting('martial_arts_training_pro_product_btn',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_textarea_field',
  ));
  $wp_customize->add_control('martial_arts_training_pro_product_btn',array(
    'label' => __('Product Button ','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_product',
    'setting' => 'martial_arts_training_pro_product_btn',
    'type'  => 'text'
  ));
    $wp_customize->add_setting( 'martial_arts_training_pro_product_color_settings',
      array(
      'default' => '',
      'transport' => 'postMessage',
      'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_product_color_settings',
        array(
        'label' => __('Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_product'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_product_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_main_heading_color', array(
      'label' => __('Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_main_heading_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_product_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_product_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_product',
        'label'    => __( 'Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_product_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_title_color', array(
      'label' => __('Product Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_product_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_product_title_font_family', array(
        'section'  => 'martial_arts_training_pro_product',
        'label'    => __( 'Product Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    
    $wp_customize->add_setting( 'martial_arts_training_pro_product_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_text_color', array(
      'label' => __('Product List Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_text_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_product_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_product_text_font_family', array(
        'section'  => 'martial_arts_training_pro_product',
        'label'    => __( 'Product List Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_product_price_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_price_color', array(
      'label' => __('Product Price Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_price_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_product_price_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_product_price_font_family', array(
        'section'  => 'martial_arts_training_pro_product',
        'label'    => __( 'Product Price Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_product_btn_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_btn_color', array(
      'label' => __('Product Button Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_btn_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_product_btn_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_product_btn_font_family', array(
        'section'  => 'martial_arts_training_pro_product',
        'label'    => __( 'Product Button Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_product_btn_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_btn_bgcolor', array(
      'label' => __('Product Button Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_btn_bgcolor',
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_product_star_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_product_star_color', array(
      'label' => __('Product Rating Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_product',
      'settings' => 'martial_arts_training_pro_product_star_color',
    )));

  // -------------- Calender ------------

  $wp_customize->add_section('martial_arts_training_pro_calender',array(
    'title' => __('Calendar','martial-arts-training-pro'),
    'description' => __('Add Calendar Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_calender_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_calender_enable',
    array(
      'label' => esc_html__( 'Show or Hide Calendar Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_calender'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_calender_enable', array(
    'selector' => '#calender .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_calender_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_calender_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_calender_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_calender_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender',
    'settings' => 'martial_arts_training_pro_calender_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_calender_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_calender_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender',
    'settings' => 'martial_arts_training_pro_calender_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_calender_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_calender_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_calender_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calender_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender',
    'setting' => 'martial_arts_training_pro_calender_main_heading',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_calender_icon',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_calender_icon',array(
    'label' => __('Calendar Icon','martial-arts-training-pro'),
    'description' => __('Add Font Awesome class Here','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender',
    'setting' => 'martial_arts_training_pro_calender_icon',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_calender_time_count',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('martial_arts_training_pro_calender_time_count',array(
    'label' => __('No of Time Slot To Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_calender',
    'setting' => 'martial_arts_training_pro_calender_time_count',
    'type'  => 'number'
  ));
  $time_count = get_theme_mod('martial_arts_training_pro_calender_time_count');

  for($i=1; $i<=$time_count; $i++) {

    $wp_customize->add_setting('martial_arts_training_pro_calender_weekend_time'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_calender_weekend_time'.$i,array(
      'label' => __('Calendar Time ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_calender',
      'setting' => 'martial_arts_training_pro_calender_weekend_time'.$i,
      'type'  => 'text'
    ));
  }

  for ($x = 1; $x<= 7; $x++) {

    $wp_customize->add_setting('martial_arts_training_pro_calender_weekend'.$x,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_calender_weekend'.$x,array(
      'label' => __('Calendar Days ','martial-arts-training-pro').$x,
      'section' => 'martial_arts_training_pro_calender',
      'setting' => 'martial_arts_training_pro_calender_weekend'.$x,
      'type'  => 'text'
    ));

    $wp_customize->add_setting('martial_arts_training_pro_calender_content_count'.$x,array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_calender_content_count'.$x,array(
      'label' => __('No of Box To Show ','martial-arts-training-pro').$x,
      'section' => 'martial_arts_training_pro_calender',
      'setting' => 'martial_arts_training_pro_calender_content_count'.$x,
      'type'  => 'number'
    ));

    $content_count = get_theme_mod('martial_arts_training_pro_calender_content_count'.$x);

    for ($j = 1; $j <= $content_count ; $j++) {
      $wp_customize->add_setting('martial_arts_training_pro_calender_weekend_title'.$x.$j,array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field',
      ));
      $wp_customize->add_control('martial_arts_training_pro_calender_weekend_title'.$x.$j,array(
        'label' => __('Calendar Title ','martial-arts-training-pro').$j,
        'section' => 'martial_arts_training_pro_calender',
        'setting' => 'martial_arts_training_pro_calender_weekend_title'.$x.$j,
        'type'  => 'text'
      )); 
      $wp_customize->add_setting('martial_arts_training_pro_calender_weekend_text'.$x.$j,array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field',
      ));
      $wp_customize->add_control('martial_arts_training_pro_calender_weekend_text'.$x.$j,array(
        'label' => __('Calendar Text ','martial-arts-training-pro').$j,
        'section' => 'martial_arts_training_pro_calender',
        'setting' => 'martial_arts_training_pro_calender_weekend_text'.$x.$j,
        'type'  => 'text'
      ));  
    }
}
    $wp_customize->add_setting( 'martial_arts_training_pro_calender_color_settings',
      array(
      'default' => '',
      'transport' => 'postMessage',
      'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_calender_color_settings',
        array(
        'label' => __('Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_calender'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_calender_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_main_heading_color', array(
      'label' => __('Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_main_heading_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_calender_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calender_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_calender',
        'label'    => __( 'Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_calender_time_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_time_color', array(
      'label' => __('Calendar Time Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_time_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_calender_time_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calender_time_font_family', array(
        'section'  => 'martial_arts_training_pro_calender',
        'label'    => __( 'Calendar Time Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_calender_days_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_days_color', array(
      'label' => __('Calendar Days Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_days_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_calender_days_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calender_days_font_family', array(
        'section'  => 'martial_arts_training_pro_calender',
        'label'    => __( 'Calendar Days Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_calender_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_title_color', array(
      'label' => __('Calendar Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_calender_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calender_title_font_family', array(
        'section'  => 'martial_arts_training_pro_calender',
        'label'    => __( 'Calendar Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    
    $wp_customize->add_setting( 'martial_arts_training_pro_calender_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_text_color', array(
      'label' => __('Calendar List Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_text_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_calender_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_calender_text_font_family', array(
        'section'  => 'martial_arts_training_pro_calender',
        'label'    => __( 'Calendar List Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_calender_hover_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_hover_bgcolor', array(
      'label' => __('Calendar Hover Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_hover_bgcolor',
    )));
    $wp_customize->add_setting( 'martial_arts_training_pro_calender_icon_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_icon_color', array(
      'label' => __('Calendar Icon Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_icon_color',
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_calender_icon_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_calender_icon_bgcolor', array(
      'label' => __('Calendar Icon Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_calender',
      'settings' => 'martial_arts_training_pro_calender_icon_bgcolor',
    )));

    
  // -------------- Diet ------------

  $wp_customize->add_section('martial_arts_training_pro_diet',array(
    'title' => __('Diet','martial-arts-training-pro'),
    'description' => __('Add Diet Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_diet_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
  $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_diet_enable',
    array(
      'label' => esc_html__( 'Show or Hide Diet Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_diet'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_diet_enable', array(
    'selector' => '#diet .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_diet_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_diet_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_diet_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_diet_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_diet_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_diet_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_diet_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_diet_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_diet_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'setting' => 'martial_arts_training_pro_diet_main_heading',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_diet_left_img',array(
      'default' => '',
      'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_diet_left_img',
    array(
      'label' => __('Diet Left Image ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_diet',
      'settings' => 'martial_arts_training_pro_diet_left_img'
  )));
  $wp_customize->add_setting('martial_arts_training_pro_diet_count',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('martial_arts_training_pro_diet_count',array(
    'label' => __('No Of Diet Box To Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'setting' => 'martial_arts_training_pro_diet_count',
    'type'  => 'number'
  ));
  $diet_count = get_theme_mod('martial_arts_training_pro_diet_count');

  for($i=1; $i<=$diet_count; $i++) {

    $wp_customize->add_setting('martial_arts_training_pro_diet_img'.$i,array(
      'default' => '',
      'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'martial_arts_training_pro_diet_img'.$i,
          array(
            'label' => __('Diet Image ','martial-arts-training-pro').$i,
            'section' => 'martial_arts_training_pro_diet',
            'settings' => 'martial_arts_training_pro_diet_img'.$i
    )));
    $wp_customize->add_setting('martial_arts_training_pro_diet_title'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_diet_title'.$i,array(
      'label' => __('Diet Title ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_diet',
      'setting' => 'martial_arts_training_pro_diet_title'.$i,
      'type'  => 'text'
    ));
    $wp_customize->add_setting('martial_arts_training_pro_diet_text'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_diet_text'.$i,array(
      'label' => __('Diet Text ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_diet',
      'setting' => 'martial_arts_training_pro_diet_text'.$i,
      'type'  => 'text'
    ));  
    $wp_customize->add_setting('martial_arts_training_pro_diet_btn'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_diet_btn'.$i,array(
      'label' => __('Diet Button ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_diet',
      'setting' => 'martial_arts_training_pro_diet_btn'.$i,
      'type'  => 'text'
    )); 
    $wp_customize->add_setting('martial_arts_training_pro_diet_btn_url'.$i,array(
      'default' => '',
      'sanitize_callback' => 'sanitize_textarea_field',
    ));
    $wp_customize->add_control('martial_arts_training_pro_diet_btn_url'.$i,array(
      'label' => __('Diet Button Url ','martial-arts-training-pro').$i,
      'section' => 'martial_arts_training_pro_diet',
      'setting' => 'martial_arts_training_pro_diet_btn_url'.$i,
      'type'  => 'text'
    ));
  }

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_color_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_diet_color_settings',
      array(
      'label' => __('Section Color Settings ','martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_diet'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_main_heading_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_diet_main_heading_color', array(
    'label' => __('Main Heading Color', 'martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_main_heading_color',
  )));
  $wp_customize->add_setting('martial_arts_training_pro_diet_main_heading_font_family',array(
    'default' => '',
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
  ));
  $wp_customize->add_control(
      'martial_arts_training_pro_diet_main_heading_font_family', array(
      'section'  => 'martial_arts_training_pro_diet',
      'label'    => __( 'Main Heading Fonts','martial-arts-training-pro'),
      'type'     => 'select',
      'choices'  => $font_array,
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_title_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_diet_title_color', array(
    'label' => __('Diet Title Color', 'martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_title_color',
  )));

  $wp_customize->add_setting('martial_arts_training_pro_diet_title_font_family',array(
    'default' => '',
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
  ));
  $wp_customize->add_control(
      'martial_arts_training_pro_diet_title_font_family', array(
      'section'  => 'martial_arts_training_pro_diet',
      'label'    => __( 'Diet Title Fonts','martial-arts-training-pro'),
      'type'     => 'select',
      'choices'  => $font_array,
  ));
  
  $wp_customize->add_setting( 'martial_arts_training_pro_diet_text_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_diet_text_color', array(
    'label' => __('Diet List Color', 'martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_text_color',
  )));

  $wp_customize->add_setting('martial_arts_training_pro_diet_text_font_family',array(
    'default' => '',
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
  ));
  $wp_customize->add_control(
      'martial_arts_training_pro_diet_text_font_family', array(
      'section'  => 'martial_arts_training_pro_diet',
      'label'    => __( 'Diet List Fonts','martial-arts-training-pro'),
      'type'     => 'select',
      'choices'  => $font_array,
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_btn_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_diet_btn_color', array(
    'label' => __('Diet Button Color', 'martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_btn_color',
  )));

  $wp_customize->add_setting('martial_arts_training_pro_diet_btn_font_family',array(
    'default' => '',
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
  ));
  $wp_customize->add_control(
      'martial_arts_training_pro_diet_btn_font_family', array(
      'section'  => 'martial_arts_training_pro_diet',
      'label'    => __( 'Diet Button Fonts','martial-arts-training-pro'),
      'type'     => 'select',
      'choices'  => $font_array,
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_diet_box_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_diet_box_bgcolor', array(
    'label' => __('Diet Box Hover Color', 'martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_diet',
    'settings' => 'martial_arts_training_pro_diet_box_bgcolor',
  )));

  // -------------- News -----------------

  $wp_customize->add_section('martial_arts_training_pro_latest_news',array(
    'title' => __('Latest News','martial-arts-training-pro'),
    'description' => __('Add Latest News Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
  $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_latest_news_enable',
    array(
      'label' => esc_html__( 'Show or Hide News Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_latest_news'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_latest_news_enable', array(
    'selector' => '#latest_news .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_latest_news_enable',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_latest_news_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_latest_news'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_latest_news',
    'settings' => 'martial_arts_training_pro_latest_news_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_latest_news_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_latest_news_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_latest_news',
    'settings' => 'martial_arts_training_pro_latest_news_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_latest_news_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_latest_news'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_latest_news_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_latest_news_main_heading',array(
    'label' => __('Section Main Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_latest_news',
    'setting' => 'martial_arts_training_pro_latest_news_main_heading',
    'type'    => 'text'
  )); 

  $wp_customize->add_setting('martial_arts_training_pro_latest_news_number',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_latest_news_number',array(
    'label' => __('No Of News To Show','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_latest_news',
    'setting' => 'martial_arts_training_pro_latest_news_number',
    'type'    => 'number'
  ));

    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_color_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_latest_news_color_settings',
        array(
        'label' => __('Latest News Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_latest_news'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_main_heading_color', array(
      'label' => __('Latest News Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_latest_news',
      'settings' => 'martial_arts_training_pro_latest_news_main_heading_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_latest_news_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_latest_news_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_latest_news',
        'label'    => __( 'Latest News Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_title_color', array(
      'label' => __('Latest News Tittle Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_latest_news',
      'settings' => 'martial_arts_training_pro_latest_news_title_color',
    )));

    $wp_customize->add_setting('martial_arts_training_pro_latest_news_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_latest_news_title_font_family', array(
        'section'  => 'martial_arts_training_pro_latest_news',
        'label'    => __( 'Latest News Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_icon_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_icon_color', array(
      'label' => __('Latest News Icon Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_latest_news',
      'settings' => 'martial_arts_training_pro_latest_news_icon_color',
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_icon_title_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_icon_title_color', array(
      'label' => __('Latest News Icon Title Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_latest_news',
      'settings' => 'martial_arts_training_pro_latest_news_icon_title_color',
    )));
   $wp_customize->add_setting('martial_arts_training_pro_latest_news_icon_title_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_latest_news_icon_title_font_family', array(
        'section'  => 'martial_arts_training_pro_latest_news',
        'label'    => __( 'Latest News Icon Title Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
   
    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_date_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_date_color', array(
      'label' => __('Latest News date Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_latest_news',
      'settings' => 'martial_arts_training_pro_latest_news_date_color',
    )));

   
    $wp_customize->add_setting('martial_arts_training_pro_latest_news_date_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_latest_news_date_font_family', array(
        'section'  => 'martial_arts_training_pro_latest_news',
        'label'    => __( 'Latest News Date Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_latest_news_date_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_latest_news_date_bgcolor', array(
      'label' => __('Latest News Date Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_latest_news',
      'settings' => 'martial_arts_training_pro_latest_news_date_bgcolor',
    )));

  // ------------ Newsletter --------------

  $wp_customize->add_section('martial_arts_training_pro_newsletter',array(
    'title' => __('Newsletter','martial-arts-training-pro'),
    'description' => __('Add Newsletter Content Here','martial-arts-training-pro'),
    'panel' => 'martial_arts_training_pro_panel_id',
  ));
  $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_enable',
    array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
  $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_newsletter_enable',
    array(
      'label' => esc_html__( 'Show or Hide Section', 'martial-arts-training-pro' ),
      'section' => 'martial_arts_training_pro_newsletter'
  )));
  $wp_customize->selective_refresh->add_partial( 'martial_arts_training_pro_newsletter_enable', array(
    'selector' => '#newsletter .container',
    'render_callback' => 'martial_arts_training_pro_customize_partial_martial_arts_training_pro_newsletter_enable',
  ));

  $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_newsletter_settings',
    array(
    'label' => __('Section Background Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter'
  )));
  $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_bgcolor', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
  ));
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_newsletter_bgcolor', array(
    'label' => __('Section Background Color', 'martial-arts-training-pro'),
    'description'   => __('Either add background color or background image, if you add both background color will be top most priority','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter',
    'settings' => 'martial_arts_training_pro_newsletter_bgcolor',
  )));
  
  $wp_customize->add_setting('martial_arts_training_pro_newsletter_bgimage',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'martial_arts_training_pro_newsletter_bgimage',array(
    'label' => __('Section Background Image','martial-arts-training-pro'),
    'description' => __('Dimention 1600 * 800','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter',
    'settings' => 'martial_arts_training_pro_newsletter_bgimage'
  )));

  $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_content_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
  ));
  $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_newsletter_content_settings',
    array(
    'label' => __('Section Content Settings','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter'
  )));

  $wp_customize->add_setting('martial_arts_training_pro_newsletter_main_heading',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_newsletter_main_heading',array(
    'label' => __('Newsletter Heading','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter',
    'setting' => 'martial_arts_training_pro_newsletter_main_heading',
    'type'    => 'text'
  ));
  $wp_customize->add_setting('martial_arts_training_pro_newsletter_text',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_newsletter_text',array(
    'label' => __('Newsletter Text','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter',
    'setting' => 'martial_arts_training_pro_newsletter_text',
    'type'    => 'text'
  )); 

  $wp_customize->add_setting('martial_arts_training_pro_newsletter_shortcode',array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('martial_arts_training_pro_newsletter_shortcode',array(
    'label' => __('Newsletter Shortcode','martial-arts-training-pro'),
    'description' => __('Add Contact Form Shortcode Here','martial-arts-training-pro'),
    'section' => 'martial_arts_training_pro_newsletter',
    'setting' => 'martial_arts_training_pro_newsletter_shortcode',
    'type'    => 'text'
  )); 

    $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_color_settings',
    array(
    'default' => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'martial_arts_training_pro_text_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_training_pro_Themes_Seperator_custom_Control( $wp_customize, 'martial_arts_training_pro_newsletter_color_settings',
        array(
        'label' => __('Newsletter Section Color Settings ','martial-arts-training-pro'),
        'section' => 'martial_arts_training_pro_newsletter'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_main_heading_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_newsletter_main_heading_color', array(
      'label' => __('Newsletter Main Heading Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_newsletter',
      'settings' => 'martial_arts_training_pro_newsletter_main_heading_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_newsletter_main_heading_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_newsletter_main_heading_font_family', array(
        'section'  => 'martial_arts_training_pro_newsletter',
        'label'    => __( 'Newsletter Main Heading Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_text_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_newsletter_text_color', array(
      'label' => __('Newsletter Text Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_newsletter',
      'settings' => 'martial_arts_training_pro_newsletter_text_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_newsletter_text_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_newsletter_text_font_family', array(
        'section'  => 'martial_arts_training_pro_newsletter',
        'label'    => __( 'Newsletter Text Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_button_color', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_newsletter_button_color', array(
      'label' => __('Newsletter Button Color', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_newsletter',
      'settings' => 'martial_arts_training_pro_newsletter_button_color',
    )));
    $wp_customize->add_setting('martial_arts_training_pro_newsletter_button_font_family',array(
      'default' => '',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'martial_arts_training_pro_sanitize_choices'
    ));
    $wp_customize->add_control(
        'martial_arts_training_pro_newsletter_button_font_family', array(
        'section'  => 'martial_arts_training_pro_newsletter',
        'label'    => __( 'Newsletter Button Fonts','martial-arts-training-pro'),
        'type'     => 'select',
        'choices'  => $font_array,
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_newsletter_button_bgcolor', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'martial_arts_training_pro_newsletter_button_bgcolor', array(
      'label' => __('Newsletter Button Background', 'martial-arts-training-pro'),
      'section' => 'martial_arts_training_pro_newsletter',
      'settings' => 'martial_arts_training_pro_newsletter_button_bgcolor',
    )));
    
    // --------------- Post General Settings ---------------

    $wp_customize->add_section('martial_arts_training_pro_post_general_settings',array(
      'title' => __('Post Settings','martial-arts-training-pro'),
      'description'   => __('Change Your Setting','martial-arts-training-pro'),
      'priority'  => null,
      'panel' => 'martial_arts_training_pro_panel_id',
    ));
    $wp_customize->add_setting( 'martial_arts_training_pro_theme_loader',
    array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_theme_loader',
    array(
        'label' => esc_html__( 'Show or Hide Loader', 'martial-arts-training-pro' ),
        'section' => 'martial_arts_training_pro_post_general_settings'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_date',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     ));
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_date',
       array(
          'label' => esc_html__( 'Show or Hide Post Date', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
    )));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_comments',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
    ));
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_comments',
       array(
          'label' => esc_html__( 'Show or Hide Comments', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_author',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_author',
       array(
          'label' => esc_html__( 'Show or Hide Author', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_share',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_share',
       array(
          'label' => esc_html__( 'Show or Hide Share Icons', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_share_facebook',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_share_facebook',
       array(
          'label' => esc_html__( 'Post Share Facebook', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_share_linkedin',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_share_linkedin',
       array(
          'label' => esc_html__( 'Post Share Linkedin', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_share_googleplus',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_share_googleplus',
       array(
          'label' => esc_html__( 'Post Share Google Plus', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_share_twitter',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_share_twitter',
       array(
          'label' => esc_html__( 'Post Share Twitter', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_category',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_category',
       array(
          'label' => esc_html__( 'Show or Hide Category', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

    $wp_customize->add_setting( 'martial_arts_training_pro_post_general_settings_post_sidebar',
     array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'martial_arts_switch_sanitization'
     )
    );
   
    $wp_customize->add_control( new martial_arts_Toggle_Switch_Custom_control( $wp_customize, 'martial_arts_training_pro_post_general_settings_post_sidebar',
       array(
          'label' => esc_html__( 'Show or Hide Sidebar', 'martial-arts-training-pro' ),
          'section' => 'martial_arts_training_pro_post_general_settings'
       )
    ));

?>