(function($) {
    function resetColorsToDefault() {
        // Define default values for your color settings
        const defaultColors = {
            'background_color': '#ffffff',
            'fitness_insight_primary_color': '#fe7d15',
            'fitness_insight_second_color': '#fd5e48',
            'fitness_insight_third_color': '#f2bb1e',
            'fitness_insight_heading_color': '#2c2c2c',
            'fitness_insight_text_color' :'#666c6e',
            'fitness_insight_primary_fade': '#f5e3b2',
            'fitness_insight_footer_bg': '#2c2c2c',
            'fitness_insight_post_bg': '#ffffff',
        };

        // Iterate over each setting and set it to its default value
        for (let settingId in defaultColors) {
            wp.customize(settingId).set(defaultColors[settingId]);
        }

        // Optionally refresh the preview
        wp.customize.previewer.refresh();
    }

    // Attach reset function to global scope
    window.resetColorsToDefault = resetColorsToDefault;

    $(document).ready(function() {
        $('.color-reset-btn').val('RESET'); // This adds the 'RESET' text inside the button
    });
})(jQuery);